(function() {
  //    FILE:EventModel
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 7/03/14
  //    Farmerswife SL.
  define(['Backbone', 'moment', 'models/request/RequestModel'], function(Backbone, Moment, RequestModel) {
    var TodoModel;
    return TodoModel = (function() {
      class TodoModel extends Backbone.Model {
        initialize() {
          return this.reqMdl = new RequestModel();
        }

        get_todo_details(usr) {
          var jsonReq, ref, response, that, xmlReq;
          jsonReq = this.reqMdl.get('JGetTodo');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'todoID', this.get('todoID'));
          this.reqMdl.__setNodeValue(jsonReq, 'type', this.get('type'));
          if (this.get('type') === 'forAnotherByMe') {
            this.reqMdl.__setNodeValue(jsonReq, 'addedToUserID', this.get('addedToUserID'));
          }
          if ((ref = this.get('type')) === 'contactForMe' || ref === 'contactForAnotherByMe') {
            this.reqMdl.__setNodeValue(jsonReq, 'contactID', this.get('contactID'));
          }
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj;
            jsonObj = data;
            //console.log data
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              window.location.href = 'index.html?expired=1';
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              that.set(jsonObj.Result.Todo, {
                silent: true
              });
              return that.trigger('todoFilled');
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
        }

        get_todo_structure(usr) {
          var jsonReq, response, that, xmlReq;
          jsonReq = this.reqMdl.get('JGetTodoStructures');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj, mdlInfo;
            jsonObj = data;
            //console.log data
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              window.location.href = 'index.html?expired=1';
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              mdlInfo = {
                todoStructure: jsonObj.Result.Title
              };
              that.save(mdlInfo, {
                silent: true
              });
              return that.trigger('todoStructureChanged');
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
        }

        get_structure_titles() {
          return this.get('todoStructure');
        }

        set_todo_isdone(usr, completed) {
          var jsonReq, response, that, xmlReq;
          jsonReq = this.reqMdl.get('JSetTodoIsDone');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'todoID', this.get('todoID'));
          this.reqMdl.__setNodeValue(jsonReq, 'isDone', completed);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj, mdlInfo;
            jsonObj = data;
            //console.log data
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              window.location.href = 'index.html?expired=1';
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              mdlInfo = {
                isDone: completed
              };
              if (completed === "0" || completed === 0) {
                mdlInfo["done"] = 0;
                mdlInfo["isDone"] = 0;
                mdlInfo["recent"] = 0;
              } else {
                mdlInfo["done"] = 1;
                mdlInfo["isDone"] = 1;
                mdlInfo["recent"] = 1;
              }
              that.save(mdlInfo, {
                silent: true
              });
              that.trigger('todoFieldChanged');
              return that.collection.trigger('collectionTodosFilled');
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
        }

        set_todo_isdeclined(usr, declined) {
          var jsonReq, response, that, xmlReq;
          jsonReq = this.reqMdl.get('JSetTodoIsDeclined');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'todoID', this.get('todoID'));
          this.reqMdl.__setNodeValue(jsonReq, 'isDeclined', declined);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj;
            jsonObj = data;
            //console.log data
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              window.location.href = 'index.html?expired=1';
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              that.save({
                declined: declined
              }, {
                silent: true
              });
              that.trigger('todoFieldChanged');
              return that.collection.trigger('collectionTodosFilled');
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
        }

        set_todo_replyNote(usr, replyNote) {
          var jsonReq, response, that, xmlReq;
          jsonReq = this.reqMdl.get('JSetTodoReplyNote');
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          this.reqMdl.__setNodeValue(jsonReq, 'todoID', this.get('todoID'));
          this.reqMdl.__setNodeValue(jsonReq, 'replyNote', replyNote);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj;
            jsonObj = data;
            //console.log data
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              window.location.href = 'index.html?expired=1';
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              that.save({
                replyNote: replyNote
              }, {
                silent: true
              });
              that.trigger('todoFieldChanged');
              return that.collection.trigger('collectionTodosFilled');
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
        }

        save_todo(usr) {
          var jsonReq, parent, response, that, xmlReq;
          jsonReq = this.reqMdl.get('JCommitTodo');
          parent = 'Todo';
          this.reqMdl.__setNodeValue(jsonReq, 'sessionID', usr.get('sessionID'));
          if (this.get('todoID')) {
            this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'todoID', this.get('todoID'));
          }
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'note', window.html_entities(this.get('note')));
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'isDone', this.get('isDone'));
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'title', this.get('title'));
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'priority', this.get('priority'));
          if (this.get('type')) {
            this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'type', this.get('type'));
          }
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'declined', this.get('declined'));
          if (this.get('addedToUserID')) {
            this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'assignedToID', this.get('addedToUserID'));
          }
          if (this.get('contactID')) {
            this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'linkedToID', this.get('contactID'));
          }
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'projectID', this.get('projectID'));
          this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'replyNote', window.html_entities(this.get('replyNote')));
          if (this.get('wasAssignedToID')) {
            this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'wasAssignedToID', this.get('wasAssignedToID'));
          }
          if (this.get('wasLinkedToID')) {
            this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'wasLinkedToID', this.get('wasLinkedToID'));
          }
          if (this.get('forDateAndTime')) {
            this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'forDateAndTime', this.get('forDateAndTime'));
          } else if (this.get('forDate')) {
            this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'forDate', this.get('forDate'));
          }
          if (this.get('alarmMinutesBefore')) {
            this.reqMdl.__setNodeValueWithObjectParent(jsonReq, parent, 'alarmMinutesBefore', this.get('alarmMinutesBefore'));
          }
          xmlReq = this.reqMdl.__getXML(jsonReq);
          that = this;
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj;
            jsonObj = data;
            //console.log data
            if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
              window.localStorage.clear();
              window.location.href = 'index.html?expired=1';
            }
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              //that.save({declined:declined},{silent:true})
              that.trigger('todoSaved');
              return that.collection.trigger('collectionTodosFilled');
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          }).always(function(data, textStatus) {
            return $.mobile.loading('hide');
          });
        }

      };

      TodoModel.prototype.defaults = {
        "forDate": Moment().format('YYYY-MM-DD'),
        "priority": 0,
        "isDone": 0,
        "todoID": "new",
        "note": "",
        "replyNote": "",
        "projectID": "",
        "type": ""
      };

      return TodoModel;

    }).call(this);
  });

}).call(this);
